<?php

declare(strict_types=1);

namespace Erlage\Photogram\Exceptions;

use Exception;

/**
 * session exception is used to indicate that session is either
 * invalid, or not verified, or user is banned or not allowed
 * to autheticate. this exception is reserved for this particular
 * use case.
 * 
 * Request processing will make sure to send at least the user object
 * to client when there's session exception.
 *  
 */
final class SessionException extends Exception
{
    public function __construct(string $message = 'Session cannot be completed.')
    {
        parent::__construct($message);
    }
}
